export default class MaterialEditorService {
    static $inject = ['$http'];

    MaterialEditorUrl = '/rest/materialeditor/';

    constructor($http) {
        this.$http = $http;
    }
    getMaterialList() {
        return this.$http.get(this.MaterialEditorUrl + 'list').then(response => response.data);
    }
    getMaterialDetails(guid) {
        return this.$http.get(this.MaterialEditorUrl + guid).then(response => {
        	return response.data
    	});
    }
    setMaterialDetails(guid, json) {
        return this.$http.put(this.MaterialEditorUrl + guid, json);
    }
    setMaterialShader(guid, value) {
        return this.$http.put(this.MaterialEditorUrl + guid + '/shader', value);
    }
    saveToDevFolder(guid) {
        return this.$http.post(this.MaterialEditorUrl + guid + '/persist', null);
    }
}
