angular.module('condenseText', []).directive('condenseText', function($timeout) {
    return {
        link: function($scope, $elem, $attrs) {
            $attrs.$observe('condenseText', function() {
                $timeout(function() {
                    scaleText();
                })
            });

            $scope.$on('CONDENSE_TEXT:SCALE_TEXT', function() {
                $timeout(function() {
                    scaleText();
                })
            });

            function scaleText() {
                resetCss();

                $elem.ready(function() {
                    var containerElem = $elem.parent();
                    if (containerElem.length === 0) {
                        resetCss();
                    }

                    if ($elem[0].clientWidth > containerElem[0].clientWidth) {
                        var scaleX = containerElem[0].clientWidth / $elem[0].clientWidth;
                        setCss(scaleX);
                    }
                });
            }

            function setCss(scaleX) {
                $elem.css({
                    transform: `scaleX(${scaleX})`
                });
            }

            function resetCss() {
                $elem.css({
                    transform: 'initial'
                });
            }
        }
    }
});
