angular.module('dynamicDataField', []).component('dynamicDataField', {
    bindings: {
        driver: '<',
        drivers: '<',
        sessionInfo: '<',
        pitLaneDuration: '<',
        pitBoxDuration: '<',
        pitLaneTimerEnabled: '<',
        pitBoxTimerEnabled: '<',
        overlayInfo: '<',
        startingOrder: '<',
        carClass: '<',
        tires: '<'
    },
    templateUrl: 'src/components/dynamicdatafield/dynamicdatafield.html',
    controller: function(broadcastService, sessionService, standingsService, utilService, $timeout) {
        var ctrl = this;
        ctrl.closingDelay = 5000; // Delay before stopping showing pit duration

        this.$onChanges = function(changes) {
            if (changes.pitLaneDuration) {
                var currentPitLaneTimer = _.get(changes, 'pitLaneDuration.currentValue');
                var previousPitLaneTimer = _.get(changes, 'pitLaneDuration.previousValue');

                if (currentPitLaneTimer > 0) {
                    ctrl.displayedPitLaneDuration = currentPitLaneTimer;
                } else if (!currentPitLaneTimer && previousPitLaneTimer > 0) {
                    $timeout(function() {
                        ctrl.displayedPitLaneDuration = 0;
                        ctrl.displayedPitBoxDuration = 0;
                    }, ctrl.closingDelay);
                }
            }

            if (changes.pitBoxDuration) {
                var currentPitBoxTimer = _.get(changes, 'pitBoxDuration.currentValue');
                var previousPitBoxTimer = _.get(changes, 'pitBoxDuration.previousValue');

                if (currentPitBoxTimer > 0) {
                    ctrl.displayedPitBoxDuration = currentPitBoxTimer;
                } else if (!currentPitBoxTimer && previousPitBoxTimer > 0 && !ctrl.pitLaneTimerEnabled) {
                    $timeout(function() {
                        ctrl.displayedPitBoxDuration = 0;
                    }, ctrl.closingDelay)
                }
            }
        }

        this.showArrow = function() {
            var positionChangeAmount = getPositionChangeAmount();
            return isShowingPositionChange() && (positionChangeAmount > 0 || positionChangeAmount < 0);
        }

        function getSelectedCarClass() {
            return ctrl.carClass;
        }

        function isMixedMode() {
            return broadcastService.isMixedClassMode(getSelectedCarClass());
        }

        function isShowingPositionChange() {
            var dynamicData = _.get(ctrl, 'overlayInfo.dynamicData');

            return dynamicData === 'positionChange'
                && sessionService.isRaceSession(ctrl.sessionInfo)
                && !standingsService.isDriverPitting(ctrl.driver)
                && !standingsService.isDriverDnf(ctrl.driver)
                && !standingsService.isDriverDq(ctrl.driver);
        }

        this.getArrowClass = function() {
            var positionChangeAmount = getPositionChangeAmount();
            if (!positionChangeAmount) {
                return null;
            }

            return positionChangeAmount > 0 ? 'arrow-up' : 'arrow-down';
        }

        function getPositionChangeAmount() {
            if (!ctrl.driver || !ctrl.startingOrder) {
                return null;
            }

            var driverCurrentPosition = isMixedMode() ? ctrl.driver.position : ctrl.driver.classPosition;
            var driverStartingEntry = _.find(ctrl.startingOrder, { slotID: ctrl.driver.slotID });
            if (!driverStartingEntry || !driverCurrentPosition) {
                return null;
            }

            var startingPosition = isMixedMode() ? driverStartingEntry.position : driverStartingEntry.classPosition;
            var positionChangeAmount = startingPosition - driverCurrentPosition;
            if (isNaN(positionChangeAmount)) {
                return null;
            }

            return positionChangeAmount;
        }

        this.showDynamicDataElem = function() {
            var dynamicValue = ctrl.displayDynamicValue();
            if (_.isNil(dynamicValue)) {
                return false;
            }

            return typeof dynamicValue === 'number' || dynamicValue;
        }

        this.isInSpecialState = function(entry) {
            return standingsService.isDriverDnf((entry)
                || standingsService.isDriverDq(entry))
                || (standingsService.isDriverPitting(entry) && sessionService.isRaceSession(ctrl.sessionInfo));
        }

        this.getPittingStatus = function() {
            return standingsService.isDriverPitting(ctrl.driver);
        }

        this.getRedStatus = function() {
            return standingsService.isDriverDnf(ctrl.driver) || standingsService.isDriverDq(ctrl.driver);
        }

        this.getEnergyClass = function() {
            var dynamicData = _.get(ctrl, 'overlayInfo.dynamicData');
            if (sessionService.isRaceSession(ctrl.sessionInfo) && dynamicData === 'energyRemaining') {
                var driverEnergyRemaining = _.get(ctrl, 'driver.fuelFraction');
                if (driverEnergyRemaining < 0.0095) {
                    return 'energy-low';
                }
            }

            return null;
        }

        this.displayDynamicValue = function() {
            if (!ctrl.driver || !ctrl.sessionInfo) {
                return '';
            }

            if (standingsService.isDriverDnf(ctrl.driver)) {
                return 'DNF';
            }

            if (standingsService.isDriverDq(ctrl.driver)) {
                return 'DQ';
            }

            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                // var showPitLaneTimer = ctrl.pitLaneTimerEnabled && ctrl.displayedPitLaneDuration;
                // var showPitBoxTimer = ctrl.pitBoxTimerEnabled && ctrl.displayedPitBoxDuration;
                //
                // if (!standingsService.driverIsInGarageStall(ctrl.driver) && (showPitLaneTimer || showPitBoxTimer)) {
                //     var displayedDuration ='P ';
                //
                //     if (showPitLaneTimer) {
                //         displayedDuration += utilService.secToString(ctrl.displayedPitLaneDuration, 1);
                //
                //         if (ctrl.pitBoxTimerEnabled) {
                //             if (ctrl.displayedPitBoxDuration) {
                //                 displayedDuration += ' (' + utilService.secToString(ctrl.displayedPitBoxDuration, 1) + ')';
                //             } else {
                //                 displayedDuration += ' (0.0)';
                //             }
                //         }
                //     } else if (showPitBoxTimer) {
                //         displayedDuration += utilService.secToString(ctrl.displayedPitBoxDuration, 1);
                //     }
                //
                //     return displayedDuration;
                // }

                if (standingsService.isDriverPitting(ctrl.driver)) {
                    return "Pit";
                }

                var dynamicData = _.get(ctrl, 'overlayInfo.dynamicData');
                if (dynamicData && ctrl.driver) {
                    if (dynamicData === 'pitStopCount') {
                        return ctrl.driver.pitstops;
                    }

                    if (dynamicData === 'gapToNext') {
                        return standingsService.displayLiveGapToNextDriver(ctrl.driver, !isMixedMode());
                    }

                    if (dynamicData === 'positionChange') {
                        var positionChangeAmount = getPositionChangeAmount();
                        if (!positionChangeAmount) {
                            positionChangeAmount = '-';
                        } else if (positionChangeAmount < 0) {
                            positionChangeAmount = positionChangeAmount + '';
                            positionChangeAmount = positionChangeAmount.replace('-', '');
                        }

                        return positionChangeAmount;
                    }

                    if (dynamicData === 'energyRemaining') {
                        if (ctrl.driver.carClass !== 'Hyper') {
                            return '';
                        }

                        var driverEnergyRemaining = _.get(ctrl, 'driver.fuelFraction');
                        if (_.isNil(driverEnergyRemaining)) {
                            return '-';
                        }

                        if (driverEnergyRemaining < 0.0095) {
                            return (driverEnergyRemaining * 100).toFixed(1) + '%';
                        }

                        return Math.round(driverEnergyRemaining * 100) + '%';
                    }
                }

                if ((!isMixedMode() && ctrl.driver.classPosition === 1) || (isMixedMode() && ctrl.driver.position === 1)) {
                    return 'Leader';
                }

                return standingsService.displayLiveGapToLeader(ctrl.driver, !isMixedMode());
            } else {
                // Non-race session
                if (standingsService.isDriverLapTimeValid(ctrl.driver, 'bestLapTime')
                    && ((isMixedMode() && ctrl.driver.position === 1) || (!isMixedMode() && ctrl.driver.classPosition === 1))) {
                    return utilService.secToString(ctrl.driver.bestLapTime, 3);
                }

                if (standingsService.isDriverPitting(ctrl.driver) && ctrl.driver.bestLapTime === -1) {
                    return "Pit";
                }

                return standingsService.displayBestLapTimeDiffToLeader(ctrl.driver, ctrl.drivers, !isMixedMode());
            }
        }

        this.getTireColor = function(axle) {
            const tireConfigColor = getTireConfigProp('color', axle);

            return tireConfigColor || '#000';
        }

        this.getTireCompoundName = function(axle) {
            let name = '';
            const tireConfigName = getTireConfigProp('name', axle);

            if (tireConfigName) {
                name = tireConfigName.substring(0, 2);
            } else {
                const tireIngameName = standingsService.getTireCompoundName(ctrl.driver, axle);

                if (tireIngameName) {
                    name = tireIngameName.substring(0, 1);
                }
            }

            return name;
        }

        function getTireConfigProp(propName, axle) {
            const tireName = standingsService.getTireCompoundName(ctrl.driver, axle);
            const carClass = _.get(ctrl, 'driver.carClass');

            return _.get(ctrl, `tires.${carClass}.${tireName}.${propName}`);
        }
    }
});
