angular.module('entryDataField', ['BroadcastService', 'VehicleInfoService']).component('entryDataField', {
    bindings: {
        config: '<',
        driver: '<',
        cars: '<',
        customConfig: '<'
    },
    templateUrl: 'src/components/entrydatafield/entrydatafield.html',
    controller: function(broadcastService, vehicleInfoService) {
        var ctrl = this;
        ctrl.manufacturerImageSrc = '';

        this.$onChanges = function(changes) {
            if (changes.driver || changes.cars) {
                ctrl.manufacturerImageSrc = ctrl.getManufacturerImageSrc();
            }
        }

        this.getManufacturerImageSrc = function() {
            if (!ctrl.driver || !ctrl.cars) {
                return;
            }

            const car = ctrl.cars.find(car => car.vehFile.includes(ctrl.driver.vehicleFilename));

            if (!car) {
                return;
            }

            return `/start/images/manufacturer/Brand=${car.manufacturer}.svg`;
        }

        this.getTeamImageSrc = function() {
            return broadcastService.getTeamImageSrc(ctrl.driver, ctrl.customConfig);
        }

        this.getCarNumberStyle = function() {
            return broadcastService.getCarClassColorStyle(ctrl.driver, ctrl.customConfig, 'color');
        }

        this.getCarNumber = function() {
            return vehicleInfoService.getCarNumberOverride(ctrl.driver);
        }
    }
});
