angular.module('overlay.eventSlide', []).component('eventSlideOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        sessionInfo: '<',
        schedule: '<'
    },
    templateUrl: 'src/components/eventslideoverlay/eventslide.overlay.html',
    controller: function(broadcastService, sessionService) {
        var ctrl = this;
        this.trackMapWaypoints = [];
        this.currentTrack = null;

        this.$onChanges = function(changes) {
            if (changes.sessionInfo) {
                var newTrack = _.get(changes, 'sessionInfo.currentValue.trackName');

                if (newTrack && newTrack !== this.currentTrack) {
                    ctrl.trackMapWaypoints = [];
                    broadcastService.getTrackMap().then(function(response) {
                        ctrl.trackMapWaypoints = response.data;
                    });
                }

                this.currentTrack = newTrack;
            }
        }

        this.getSeriesImageSrc = function() {
            var imageFileName = _.get(ctrl, 'customConfig.images.seriesBigImage');
            var customConfigDir = _.get(ctrl, 'config.customConfig');

            if (customConfigDir === 'default') {
                return ctrl.getDefaultSeriesImageSrc();
            } else {
                return './customize/' + customConfigDir + '/images/' + imageFileName;
            }
        }

        this.getDefaultSeriesImageSrc = function() {
            return broadcastService.getDefaultSeriesLogoUrl();
        }

        this.getAirTemp = function() {
            return this.displayTemperatureValue(_.get(ctrl, 'sessionInfo.ambientTemp'));
        }

        this.getTrackTemp = function() {
            return this.displayTemperatureValue(_.get(ctrl, 'sessionInfo.trackTemp'));
        }

        this.getWeather = function() {
            var raining = _.get(ctrl, 'sessionInfo.raining');

            return raining >= 0.2 ? 'Raining' : 'Fair';
        }

        this.displayTemperatureValue = function(temperatureValue) {
            if (_.isNil(temperatureValue)) {
                return 'N/A';
            }

            return temperatureValue.toFixed(1) + String.fromCharCode(176);
        }

        this.canShowWeatherInfo = function() {
            return !sessionService.sessionIsInvalid(ctrl.sessionInfo);
        }

        this.canShowCustomData = function() {
            var customDataEnabled = _.get(ctrl, 'overlayInfo.settings.showCustomData');
            var customData = _.get(ctrl, 'customConfig.overlays.eventSlide.customData');

            return customDataEnabled && this.customDataHasValidEntries(customData);
        }

        this.customDataHasValidEntries = function(customData) {
            if (!customData || customData.length === 0) {
                return false;
            }

            for (var i = 0; i < customData.length; i++) {
                var title = customData[i].title;
                var value = customData[i].value;

                if (title && title.length > 0 && value && value.length > 0) {
                    return true;
                }
            }

            return false;
        }

        this.getBorderStyle = function() {
            return {
                borderLeft: 'solid 0.2em' + broadcastService.getCustomConfigSeriesColor(ctrl.customConfig)
            }
        }

        this.getTrackName = function() {
            return broadcastService.getCurrentTrackNameFromSchedule(ctrl.schedule, ctrl.customConfig, ctrl.sessionInfo);
        }

        this.getTrackLocation = function() {
            var trackLocation;
            var currentRoundIndex = broadcastService.getCurrentRoundIndex(ctrl.schedule);
            if (currentRoundIndex > -1) {
                trackLocation = _.get(ctrl, 'schedule.' + currentRoundIndex + '.trackLocation');
            }

            if (!trackLocation) {
                trackLocation = _.get(ctrl, 'customConfig.trackLocation');
            }

            return trackLocation;
        }

        this.getSwipeStyle = function() {
            return {
                backgroundColor: broadcastService.getCustomConfigSeriesColor(ctrl.customConfig)
            }
        }
    }
});
