angular.module('overlay.inraceSeasonStandings', ['VehicleInfoService']).component('inraceSeasonStandingsOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        standings: '<',
        entryDataField: '<',
        selectedNameType: '<',
        driverNameTypeId: '<',
        cars: '<'
    },
    templateUrl: 'src/components/inraceseasonstandingsoverlay/inraceseasonstandings.overlay.html',
    controller: function(broadcastService, standingsService, utilService, vehicleInfoService) {
        var ctrl = this;
        ctrl.displayedStandings = [];

        this.$onChanges = function(changes) {
            if (changes.overlayInfo) {
                var selectedCarClass = ctrl.getSelectedCarClass();
                if (ctrl.standings) {
                    var standings;
                    if (broadcastService.isMixedClassMode(selectedCarClass)) {
                        standings = ctrl.standings;
                    } else {
                        standings = _.filter(
                            ctrl.standings,
                            { carClass: selectedCarClass }
                        );
                    }

                    if (standings) {
                        ctrl.displayedStandings = standings;
                    }
                }
            }
        }

        this.getCssCarClassName = function() {
            return utilService.generateCssCarClassName(_.get(ctrl, 'overlayInfo.settings.selectedCarClass'));
        }

        this.getBorderLeftStyle = function() {
            var overlaySettings = _.get(ctrl, 'overlayInfo.settings');
            var borderStyle = broadcastService.getBorderStyle(
                overlaySettings.selectedCarClass,
                ctrl.customConfig,
                'borderLeft'
            );

            if (!borderStyle) {
                return {
                    borderLeft: 'solid 4px ' + broadcastService.getCustomConfigSeriesColor(ctrl.customConfig)
                }
            }

            return borderStyle;
        }

        this.getPositionProp = function() {
            return broadcastService.isMixedClassMode(ctrl.getSelectedCarClass())
                ? 'position'
                : 'classPosition';
        }

        this.getLimitTo = function() {
            return _.get(ctrl, 'customConfig.overlays.inraceSeasonStandings.driverCount') || 10;
        }

        this.getStartIndex = function() {
            var page = ctrl.getPage();
            var driversPerPage = ctrl.getLimitTo();

            if (!page || !driversPerPage) {
                return 0;
            }

            return (page - 1) * driversPerPage;
        }

        this.getPage = function() {
            return _.get(ctrl, 'overlayInfo.settings.page');
        }

        this.getRowClass = function(entry, first, index) {
            return {
                ['slot-' + index]: index,
                first: first,
            }
        }

        this.getSelectedCarClass = function() {
            return _.get(ctrl, 'overlayInfo.settings.selectedCarClass');
        }

        this.getPosition = function(entry) {
            return broadcastService.isMixedClassMode(ctrl.getSelectedCarClass())
                ? entry.position
                : entry.classPosition;
        }

        this.displayPoints = function(driver) {
            if (!driver) {
                return '';
            }

            return driver.totalPoints;
        }
    }
});
