angular.module('controlpanel.inraceSeasonStandingsSettings', ['BroadcastService']).component('inraceSeasonStandingsSettings', {
    bindings: {
        settings: '<',
        carClasses: '<',
        seasonStandings: '<',
        customConfig: '<',
        updateSettings: '&'
    },
    templateUrl: 'src/components/inraceseasonstandingssettings/inraceseasonstandingssettings.html',
    controller: function(broadcastService) {
        var ctrl = this;
        this.selectedCarClass = null;

        this.$onChanges = function(changes) {
            if (changes.settings && changes.settings.currentValue) {
                var update = false;

                if (!this.selectedCarClass) {
                    var selectedCarClass = getSelectedCarClass();

                    if (broadcastService.isMixedClassMode(selectedCarClass)
                        || (selectedCarClass && _.includes(ctrl.carClasses, selectedCarClass))) {
                        ctrl.selectedCarClass = selectedCarClass;
                    } else {
                        ctrl.selectedCarClass = ctrl.carClasses[0];
                    }

                    update = true;
                }

                if (update) {
                    ctrl.update();
                }
            }
        }

        function getSelectedCarClass() {
            return _.get(ctrl, 'settings.selectedCarClass');
        }

        this.selectPreviousPage = function() {
            var targetPage = ctrl.settings.page - 1;

            if (targetPage > 0) {
                ctrl.settings.page = targetPage;
                ctrl.update();
            }
        }

        this.selectNextPage = function() {
            var targetPage = ctrl.settings.page + 1;

            if (targetPage <= ctrl.getMaxPages()) {
                ctrl.settings.page = targetPage;
                ctrl.update();
            }
        }

        this.isPreviousPageButtonDisabled = function() {
            if (ctrl.getMaxPages() === 0) {
                return true;
            }

            return ctrl.settings && ctrl.settings.page === 1;
        }

        this.isNextPageButtonDisabled = function() {
            if (ctrl.getMaxPages() === 0) {
                return true;
            }

            return ctrl.settings && ctrl.settings.page === ctrl.getMaxPages();
        }

        this.getEntries = function(carClass) {
            if (carClass) {
                return _.filter(ctrl.seasonStandings, { carClass: carClass });
            }

            return ctrl.seasonStandings;
        }

        this.getDriverCount = function(carClass) {
            var entries = ctrl.getEntries(carClass);
            if (!entries) {
                return 0;
            }

            return entries.length;
        }

        this.getMaxPages = function() {
            var driverCount;
            if (broadcastService.isMixedClassMode(getSelectedCarClass())) {
                driverCount = ctrl.getDriverCount(null);
            } else {
                driverCount = ctrl.getDriverCount(ctrl.selectedCarClass);
            }

            // var driversPerPage = _.get(ctrl, 'settings.driversPerPage');
            var driversPerPage = _.get(ctrl, 'customConfig.overlays.inraceSeasonStandings.driverCount') || 10;

            if (driverCount === undefined || driversPerPage === undefined) {
                return 0;
            }

            return Math.ceil(driverCount / driversPerPage);
        }

        this.onSelectedCarClassChanged = function() {
            ctrl.settings.page = 1;
            this.update();
        }

        this.update = function () {
            if (!ctrl.settings) {
                return;
            }

            ctrl.settings.selectedCarClass = ctrl.selectedCarClass;

            ctrl.updateSettings({ settings: ctrl.settings });
        }
    }
});
