angular.module('overlay.introSlide', []).component('introSlideOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        schedule: '<'
    },
    templateUrl: 'src/components/introslideoverlay/introslide.overlay.html',
    controller: function(broadcastService) {
        var ctrl = this;
        this.broadcastDirector = null;
        this.commentators = [];
        this.headerTrackName = null;

        this.$onChanges = function(changes) {
            if (changes.customConfig) {
                ctrl.commentators = _.get(
                    changes,
                    'customConfig.currentValue.overlays.introSlide.commentators',
                    []
                );
                ctrl.broadcastDirector = _.get(
                    changes,
                    'customConfig.currentValue.overlays.introSlide.broadcastDirector',
                    null
                );

                var seriesRound;
                var currentRoundIndex = broadcastService.getCurrentRoundIndex(ctrl.schedule);
                if (currentRoundIndex > -1) {
                    seriesRound = currentRoundIndex + 1;
                }

                if (!seriesRound) {
                    seriesRound = _.get(
                        changes,
                        'customConfig.currentValue.seriesRoundNumber',
                        null
                    );
                }

                if (seriesRound) {
                    ctrl.headerTrackName = 'Round ' + seriesRound;
                }
            }
        }

        this.displayHeaderTopic = function() {
            var eventDate = _.get(ctrl, 'customConfig.eventDate');

            if (eventDate) {
                return eventDate;
            }

            return new Date().toLocaleString('en-GB', { day: 'numeric', month: 'long', year: 'numeric' });
        }

        this.getFooterTitleStyle = function() {
            return {
                borderLeft: 'solid 0.2em' + broadcastService.getCustomConfigSeriesColor(ctrl.customConfig)
            }
        }
    }
});
