angular.module('controlpanel.replayEventSettings', [
    'BroadcastService',
    'VehicleInfoService'
]).component('replayEventSettings', {
    bindings: {
        drivers: '<',
        sessionInfo: '<',
        replayEvent: '<',
        index: '<',
        overlay: '<',
        updateSettings: '&',
        goToReplayEvent: '&',
        deleteEvent: '&'
    },
    templateUrl: 'src/components/replayeventsettings/replayeventsettings.html',
    controller: function(broadcastService, vehicleInfoService) {
        var ctrl = this;
        ctrl.selectedDriver = null;
        ctrl.selectedCamera = null;
        ctrl.secondsToGoBack = null;
        ctrl.focusedOnSecondsToGoBack = false;
        ctrl.cameras = broadcastService.getCameras();

        this.$onChanges = function(changes) {
            if (changes.drivers) {
                if (!ctrl.selectedDriver) {
                    if (ctrl.replayEvent) {
                        ctrl.selectedDriver = _.find(ctrl.drivers, { slotID: ctrl.replayEvent.slotID });
                    } else {
                        ctrl.selectedDriver = ctrl.drivers[0];
                    }
                }
            }

            if (changes.sessionInfo) {
                if (!ctrl.focusedOnSecondsToGoBack) {
                    ctrl.secondsToGoBack = Math.round(
                        changes.sessionInfo.currentValue.currentEventTime - ctrl.replayEvent.eventTime
                    );
                }
            }

            if (changes.replayEvent) {
                if (ctrl.drivers) {
                    ctrl.selectedDriver = _.find(ctrl.drivers, { slotID: changes.replayEvent.currentValue.slotID });
                }

                var cameraIndex = _.findIndex(ctrl.cameras, { index: changes.replayEvent.currentValue.cameraIndex });
                if (cameraIndex > -1) {
                    ctrl.selectedCamera = ctrl.cameras[cameraIndex];
                } else {
                    ctrl.selectedCamera = ctrl.cameras[0];
                }
            }
        };

        this.getDriverName = function(entry) {
            return vehicleInfoService.getDriverNameOverride(entry);
        }

        this.onFocusSecondsToGoBack = function() {
            ctrl.focusedOnSecondsToGoBack = true;
        }

        this.onBlurSecondsToGoBack = function() {
            ctrl.focusedOnSecondsToGoBack = false;
        }

        this.onUpdateSecondsToGoBack = function() {
            var newReplayEventTime = _.get(ctrl, 'sessionInfo.currentEventTime') - ctrl.secondsToGoBack;
            ctrl.onUpdateSettings(newReplayEventTime);
        }

        this.onUpdateSettings = function(eventTime = null) {
            this.updateSettings({
                replayEventIndex: ctrl.index,
                selectedDriver: ctrl.selectedDriver,
                eventTime: eventTime || _.get(ctrl, 'replayEvent.eventTime'),
                selectedCamera: ctrl.selectedCamera
            });
        }
    }
});
