angular.module('scheduleList', []).component('scheduleList', {
    bindings: {
        customConfig: '<',
        schedule: '<',
        overlayInfo: '<',
        config: '<?',
    },
    templateUrl: 'src/components/schedulelist/schedulelist.html',
    controller: function(broadcastService) {
        var ctrl = this;

        this.getEntryIsGreyedOut = function(entry) {
            var showingWhen = _.get(ctrl, 'overlayInfo.settings.showingWhen');
            return entryDateHasPassed(entry) || (showingWhen === 'postrace' && isTodayEntry(entry));
        }

        this.entryIsHighlighted = function(entry) {
            var showingWhen = _.get(ctrl, 'overlayInfo.settings.showingWhen');
            if (showingWhen === 'prerace' && isTodayEntry(entry)) {
                return true;
            } else if (showingWhen === 'postrace') {
                var nextUpEntry = findNextUpEntry();
                return nextUpEntry && nextUpEntry.date === entry.date;
            }

            return false;
        }

        function findNextUpEntry() {
            var showingWhen = _.get(ctrl, 'overlayInfo.settings.showingWhen');
            if (showingWhen === 'prerace') {
                return null;
            }

            return _.find(ctrl.schedule, function(scheduleEntry) {
                return !entryDateHasPassed(scheduleEntry) && !isTodayEntry(scheduleEntry);
            });
        }

        function isTodayEntry(entry) {
            if (!entry || !entry.date) {
                return false;
            }

            var today = new Date();
            var entryDate = new Date(entry.date);

            return entryDate.getUTCFullYear() === today.getUTCFullYear()
                && entryDate.getUTCMonth() === today.getUTCMonth()
                && entryDate.getUTCDate() === today.getUTCDate();
        }

        function entryDateHasPassed(entry) {
            if (!entry || !entry.date) {
                return false;
            }

            var today = new Date();
            var entryDate = new Date(entry.date);
            today.setHours(0, 0, 0, 0);
            entryDate.setHours(0, 0, 0, 0);

            return entryDate < today;
        }

        this.getSeriesColor = function(getTextColor = false) {
            return broadcastService.getCustomConfigSeriesColor(ctrl.customConfig, getTextColor);
        }

        this.getEntryName = function(entry, $index) {
            var name = entry.name;
            if (!name) {
                name = entry.trackName;
            }

            var prependRoundNumber = _.get(ctrl, 'customConfig.overlays.scheduleSlide.prependRoundNumber');
            if (name && prependRoundNumber) {
                if (prependRoundNumber === true) {
                    name = 'Round ' + ($index + _.get(ctrl, 'config.startIndex') + 1) + ' - ' + name;
                } else if (typeof prependRoundNumber === 'string') {
                    name = prependRoundNumber + ($index + _.get(ctrl, 'config.startIndex') + 1) + ' - ' + name;
                }
            }

            return name;
        }

        this.getDateText = function(entry) {
            var dateText = '';
            var showingWhen = _.get(ctrl, 'overlayInfo.settings.showingWhen');
            if (showingWhen === 'prerace' && isTodayEntry(entry)) {
                dateText += 'Today: ';
            } else if (showingWhen === 'postrace') {
                var nextUpEntry = findNextUpEntry();
                if (nextUpEntry && nextUpEntry.date === entry.date) {
                    dateText += 'Next up: ';
                }
            }

            return dateText + formatDate(entry.date);
        }

        function formatDate(dateStr) {
            var date = new Date(dateStr);
            if (date.toString() === 'Invalid Date') {
                return '';
            }

            var month = date.toLocaleString('en-US', { month: 'long' });

            return date.getDate() + ' ' + month + ' ' + date.getFullYear();
        }
    }
});
