angular.module('overlay.seasonStandings', []).component('seasonStandingsOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        seasonStandings: '<',
        cars: '<',
        entryDataField: '<',
        selectedEntryInfo: '<'
    },
    templateUrl: 'src/components/seasonstandingsoverlay/seasonstandings.overlay.html',
    controller: function(broadcastService, standingsService, utilService) {
        var ctrl = this;
        ctrl.displayStandings = null;
        ctrl.carImages = [];

        this.$onChanges = function(changes) {
            if (changes.overlayInfo) {
                var selectedCarClass = ctrl.getSelectedCarClass();
                if (selectedCarClass && ctrl.seasonStandings) {
                    var standings;
                    if (broadcastService.isMixedClassMode(selectedCarClass)) {
                        standings = ctrl.seasonStandings.standings;
                    } else {
                        standings = _.filter(
                            ctrl.seasonStandings.standings,
                            { carClass: selectedCarClass }
                        );
                    }

                    if (standings) {
                        ctrl.displayStandings = standings.slice(0);

                        _.forEach(ctrl.displayStandings, function(entry) {
                            var gameCar = _.find(ctrl.cars, function(car) {
                                return _.includes(car.vehFile, entry.vehicleFilename);
                            });

                            if (gameCar) {
                                if (!_.find(ctrl.carImages, { vehicleFile: entry.vehicleFilename })) {
                                    broadcastService.getDiskOrGameCarImageSrc(
                                        entry,
                                        _.get(ctrl, 'config.customConfig'),
                                        setEntryCarImageSrc,
                                        entry.vehicleFilename
                                    );
                                }
                            }
                        });
                    }
                }
            }
        }

        function setEntryCarImageSrc(src, entry) {
            if (src && entry) {
                ctrl.carImages.push({
                    vehicleFile: entry.vehicleFilename,
                    carImageSrc: src
                });
            }
        }

        this.getCarImageSrc = function(driver) {
            var entry = _.find(ctrl.carImages, { vehicleFile: driver.vehicleFilename });

            if (!entry) {
                return null;
            }

            return entry.carImageSrc;
        }

        this.displayHeaderTopic = function() {
            var seasonName = _.get(ctrl, 'customConfig.seasonName');

            if (!seasonName) {
                return 'Season standings';
            }

            return 'Season ' + seasonName + ' standings';
        }

        this.getLimitTo = function() {
            var driversPerPage = ctrl.getDriversPerPage();

            if (!driversPerPage) {
                return 10;
            }

            return driversPerPage;
        }

        this.getStartIndex = function() {
            var page = ctrl.getPage();
            var driversPerPage = ctrl.getDriversPerPage();

            if (!page || !driversPerPage) {
                return 0;
            }

            return (page - 1) * driversPerPage;
        }

        this.getPage = function() {
            return _.get(ctrl, 'overlayInfo.settings.page');
        }

        this.getDriversPerPage = function() {
            return _.get(ctrl, 'overlayInfo.settings.driversPerPage');
        }

        this.getPositionChange = function(entry) {
            if (broadcastService.isMixedClassMode(ctrl.getSelectedCarClass())) {
                return entry.previousPosition - entry.position;
            }

            return entry.previousClassPosition - entry.classPosition;
        }

        this.getSelectedCarClass = function() {
            return _.get(ctrl, 'overlayInfo.settings.selectedCarClass');
        }

        this.getPosition = function(entry) {
            if (broadcastService.isMixedClassMode(ctrl.getSelectedCarClass())) {
                return entry.position;
            }

            return entry.classPosition;
        }

        this.getCssCarClassName = function() {
            return utilService.generateCssCarClassName(ctrl.getSelectedCarClass());
        }

        this.getDynamicRowCount = function() {
            return Math.min(
                ctrl.displayStandings.length - ctrl.getStartIndex(),
                ctrl.getDriversPerPage()
            );
        }

        this.getBorderStyle = function(driver) {
            var borderStyle = broadcastService.getDriverBorderStyle(driver, ctrl.customConfig, 'borderLeft');

            if (!borderStyle) {
                return {
                    borderLeft: 'solid 4px ' + broadcastService.getCustomConfigSeriesColor(ctrl.customConfig)
                }
            }

            return borderStyle;
        }
    }
});
