angular.module('overlay.sessionInfo', []).component('sessionInfoOverlay', {
    bindings: {
        sessionInfo: '<',
        standings: '<',
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        replayTransitionOverlay: '<'
    },
    templateUrl: 'src/components/sessioninfooverlay/sessioninfo.overlay.html',
    controller: function overlaySessionInfoController(broadcastService, sessionService) {
        const ctrl = this;

        // Displays relevant session data below the ads
        this.displaySessionInfoTitle = function () {
            return broadcastService.getCustomConfigSeriesName(ctrl.customConfig) + ' - ' + ctrl.displaySessionName();
        }

        // Displays relevant session data below the ads
        this.displaySessionInfoText = function () {
            if (ctrl.replayTransitionOverlay && ctrl.replayTransitionOverlay.replayIsActive) {
                return 'Replay';
            }

            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                return sessionService.displaySessionDuration(ctrl.sessionInfo, ctrl.standings);
            }

            return sessionService.displaySessionDuration(ctrl.sessionInfo, ctrl.standings);
        }

        this.displayYellowText = () => {
            if (ctrl.code80IsEnabled()) {
                return 'Full Course Yellow';
            }

            if (ctrl.safetyCarIsEnabled()) {
                return 'Safety Car';
            }

            return 'Yellow flag';
        }

        this.code80IsEnabled = function() {
            return _.get(ctrl, 'overlayInfo.settings.code80.enabled') === true;
        }

        this.safetyCarIsEnabled = function() {
            return _.get(ctrl, 'overlayInfo.settings.safetyCar.enabled') === true;
        }

        this.getSessionNameFirstLetter = function() {
            if (!ctrl.sessionInfo || !ctrl.sessionInfo.session) {
                return '';
            }

            return ctrl.sessionInfo.session[0];
        }

        this.displaySessionName = function () {
            return sessionService.displaySessionName(this.sessionInfo);
        }

        this.isSessionYellow = () => {
            return ctrl.code80IsEnabled()
              || ctrl.safetyCarIsEnabled()
              || sessionService.getYellowSector(ctrl.sessionInfo) > 0;
        }

        this.getCheckeredClass = function() {
            return sessionService.sessionIsFinishing(ctrl.sessionInfo);
        }

        this.getTimingBarBgColor = function(getTextColor = false) {
            if (ctrl.replayTransitionOverlay && ctrl.replayTransitionOverlay.replayIsActive) {
                return broadcastService.getCustomConfigSeriesColor(ctrl.customConfig, getTextColor);
            }

            return getTextColor ? '#fff' : 'rgba(0, 0, 0, 0.7)';
        }

        /**
         * @returns {string}
         */
        this.getTimeRemainingPercentage = () => {
            if (!ctrl.sessionInfo) {
                return '0%';
            }

            const timeRemaining = ctrl.sessionInfo.endEventTime - ctrl.sessionInfo.currentEventTime;

            return timeRemaining / ctrl.sessionInfo.endEventTime * 100 + '%';
        }
    }
});
