angular.module('controlpanel.standingsTowerSettings', []).component('standingsTowerSettings', {
    bindings: {
        drivers: '<',
        driversPerPage: '<',
        page: '<',
        carClass: '<',
        showName: '<',
        dynamicData: '<',
        hideField: '<',
        entryDataField: '<',
        driverNameTypeId: '<',
        customConfig: '<',
        updateSettings: '&'
    },
    templateUrl: 'src/components/standingstowersettings/standingstowersettings.html',
    controller: function($interval) {
        this.selectedDriverNameType = null;
        this.driverNameTypes = [
            { id: 'lastName', name: 'Last name' },
            { id: 'firstName', name: 'First name' },
            { id: 'fullName', name: 'Full name' },
            { id: 'initialAndLastName', name: 'Initial & last name' },
            { id: 'threeLetters', name: 'Three letters' }
        ]

        let dynamicDataAutocycleInterval;
        this.dynamicDataAutocycleIsEnabled = false;
        this.dynamicDataAutocycleIntervalSeconds = 60; // Default, will be loaded from config.json if available.
        this.dynamicDataInputs = [
            {
                valueName: 'gapToLeader',
                description: 'Gap to Leader',
                isAutocycled: false
            },
            {
                valueName: 'gapToNext',
                description: 'Gap to Next',
                isAutocycled: false
            },
            {
                valueName: 'pitStopCount',
                description: 'Number of Stops',
                isAutocycled: false
            },
            {
                valueName: 'positionChange',
                description: 'Positions Gained/lost',
                isAutocycled: false
            },
            {
                valueName: 'energyRemaining',
                description: 'Energy Remaining',
                isAutocycled: false
            },
            {
                valueName: 'tireName',
                description: 'Tyre',
                isAutocycled: false
            }
        ];

        this.$onChanges = function(changes) {
            if (changes.drivers) {
                this.carClasses = getCarClasses(changes.drivers.currentValue);
            }

            if (changes.driverNameTypeId) {
                if (changes.driverNameTypeId.currentValue && !this.selectedDriverNameType) {
                    this.selectedDriverNameType = _.find(
                        this.driverNameTypes,
                        { id: changes.driverNameTypeId.currentValue }
                    );
                }
            }

            if (changes.customConfig) {
                const configDynamicDataAutocycleIntervalSeconds = _.get(
                    changes, 'customConfig.currentValue.overlays.tower.dynamicDataAutocycleIntervalSeconds'
                );

                if (configDynamicDataAutocycleIntervalSeconds > 0) {
                    this.dynamicDataAutocycleIntervalSeconds = configDynamicDataAutocycleIntervalSeconds;
                }
            }
        }

        this.onDynamicDataAutocycleToggled = () => {
            if (this.dynamicDataAutocycleIsEnabled) {
                const currentInput = _.find(this.dynamicDataInputs, { valueName: this.dynamicData });

                if (currentInput) {
                    currentInput.isAutocycled = true;
                }

                startDynamicDataCycling();
            } else {
                clearDynamicDataAutoCycleInterval();
            }
        }

        this.onChangeDynamicDataAutocycleInterval = () => {
            if (this.dynamicDataAutocycleIsEnabled) {
                clearDynamicDataAutoCycleInterval();
                startDynamicDataCycling();
            }
        }

        const clearDynamicDataAutoCycleInterval = () => {
            $interval.cancel(dynamicDataAutocycleInterval);
            dynamicDataAutocycleInterval = null;
        }

        const startDynamicDataCycling = () => {
            const intervalSeconds = parseInt(this.dynamicDataAutocycleIntervalSeconds);

            if (isNaN(intervalSeconds) || !intervalSeconds) {
                return;
            }

            dynamicDataAutocycleInterval = $interval(() => {
                const selectedAutocycleData = _.filter(this.dynamicDataInputs, 'isAutocycled');
                const currentIndex = _.findIndex(selectedAutocycleData, { valueName: this.dynamicData });
                let nextIndex = currentIndex + 1;

                if (nextIndex >= selectedAutocycleData.length) {
                    nextIndex = 0;
                }

                const nextDynamicData = _.get(selectedAutocycleData, `${nextIndex}.valueName`);

                if (nextDynamicData && nextDynamicData !== this.dynamicData) {
                    this.dynamicData = nextDynamicData;
                    this.update();
                }
            }, intervalSeconds * 1000);
        }

        var getCarClasses = function(standings) {
            var carClasses = [];

            _.forEach(standings, function(entry) {
                if (!_.includes(carClasses, entry.carClass)) {
                    carClasses.push(entry.carClass);
                }
            });

            return carClasses;
        }

        this.getStandingsTowerPageCount = function () {
            var drivers = this.drivers;

            if (this.carClass && this.carClass !== 'Multiclass' && this.carClass !== 'Mixed') {
                drivers = _.filter(drivers, { carClass: this.carClass });
            }

            if (!drivers || drivers.length === 0) {
                return;
            }

            var pageCount = 0;
            var driverCount = 0;
            while (driverCount <= drivers.length - 1) {
                if (pageCount === 0) {
                    driverCount += this.driversPerPage;
                } else {
                    driverCount += this.driversPerPage - 1;
                }

                pageCount++;
            }

            return pageCount;
        }

        this.update = function() {
            if (this.page > this.getStandingsTowerPageCount()) {
                this.page = this.getStandingsTowerPageCount();
            }

            this.updateSettings({
                driversPerPage: this.driversPerPage,
                page: this.page,
                carClass: this.carClass,
                showName: this.showName,
                dynamicData: this.dynamicData,
                hideField: this.hideField,
                entryDataField: this.entryDataField,
                driverNameTypeId: this.selectedDriverNameType.id
            });
        }
    }
});
