angular.module('overlay.startingOrder', ['BroadcastService']).component('startingOrderOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
        startingOrder: '<',
        entryDataField: '<',
        selectedEntryInfo: '<',
        schedule: '<',
        sessionInfo: '<',
        cars: '<'
    },
    templateUrl: 'src/components/startingorderoverlay/startingorder.overlay.html',
    controller: function(broadcastService, standingsService, utilService, $interval, $timeout) {
        var ctrl = this;
        this.selectedCarClass = null;
        this.cycleStartingOrderInterval = null;
        this.cycleIntervalDelay = 6500; // 10s delay with some "margin" for animations
        this.page = 1;
        this.perPage = 2;
        this.carImages = [];

        this.$onChanges = function(changes) {
            if (changes.overlayInfo) {
                var newVisible = _.get(changes, 'overlayInfo.currentValue.visible');
                var oldVisible = _.get(changes, 'overlayInfo.previousValue.visible');
                var newSelectedCarClass = _.get(changes, 'overlayInfo.currentValue.settings.selectedCarClass');
                var oldSelectedCarClass = _.get(changes, 'overlayInfo.previousValue.settings.selectedCarClass');
                ctrl.selectedCarClass = newSelectedCarClass;

                if (newVisible && !oldVisible) {
                    document.addEventListener('animationstart', onAnimationStart);
                    ctrl.page = 1;
                    startCycleStartingOrder();
                } else if (!newVisible && oldVisible) {
                    document.removeEventListener('animationstart', onAnimationStart);
                    ctrl.page = 1;
                    stopCycleStartingOrder();
                }

                if (newSelectedCarClass && oldSelectedCarClass && newSelectedCarClass !== oldSelectedCarClass) {
                    // Selected car class changed
                    stopCycleStartingOrder();
                    ctrl.page = 1;
                    startCycleStartingOrder();
                }
            }

            if (changes.startingOrder && changes.startingOrder.currentValue) {
                _.forEach(changes.startingOrder.currentValue, function(entry) {
                    if (!_.find(ctrl.carImages, { slotID: entry.slotID })) {
                        broadcastService.getDiskOrGameCarImageSrc(
                            entry,
                            _.get(ctrl, 'config.customConfig'),
                            setEntryCarImageSrc
                        );
                    }
                });
            }
        }

        function setEntryCarImageSrc(src, entry) {
            if (src && entry) {
                ctrl.carImages.push({
                    slotID: entry.slotID,
                    carImageSrc: src
                });
            }
        }

        function onAnimationStart(event) {
            if (event.animationName === 'enter-list-item' || event.animationName === 'enter-list-item-even-position') {
                var listElem = event.target;
                var imageElem = listElem.querySelector('img');

                if (!listElem || !imageElem) {
                    return;
                }

                $timeout(function() {
                    if (imageElem.width > 0) {
                        listElem.classList.add('image-loaded');
                    }
                }, 1000);
            }
        }

        function getMaxPages() {
            var carClassDrivers = broadcastService.isMixedClassMode(ctrl.selectedCarClass)
                ? ctrl.startingOrder
                : _.filter(ctrl.startingOrder, { carClass: ctrl.selectedCarClass });
            var carClassDriverCount = carClassDrivers && carClassDrivers.length > 0 ? carClassDrivers.length : 0;

            return Math.ceil(carClassDriverCount / ctrl.perPage);;
        }

        function startCycleStartingOrder() {
            if (ctrl.cycleStartingOrderInterval) {
                return;
            }

            ctrl.cycleStartingOrderInterval = $interval(function() {
                var newPage = ctrl.page + 1;
                var maxPages = getMaxPages();

                if (newPage > maxPages) {
                    stopCycleStartingOrder();
                } else {
                    ctrl.page = newPage;
                }
            }, ctrl.cycleIntervalDelay);
        }

        function stopCycleStartingOrder() {
            $interval.cancel(ctrl.cycleStartingOrderInterval);
            ctrl.cycleStartingOrderInterval = null;
        }

        this.getLimitToIndex = function() {
            return (ctrl.page - 1) * ctrl.perPage;
        }

        this.getPositionProp = function() {
            return broadcastService.isMixedClassMode(ctrl.selectedCarClass)
                ? 'position'
                : 'classPosition'
        }

        this.getCssCarClassName = function(carClass) {
            return utilService.generateCssCarClassName(carClass);
        }

        this.getBorderLeftStyle = function(driver) {
            return broadcastService.getDriverBorderStyle(driver, ctrl.customConfig, 'borderLeft');
        }

        this.getCarImageSrc = function(driver) {
            var entry = _.find(ctrl.carImages, { slotID: driver.slotID });

            if (!entry) {
                return null;
            }

            return entry.carImageSrc;
        }

        this.getSwipeStyle = function(driver) {
            return broadcastService.getCarClassColorStyle(
                driver,
                ctrl.customConfig,
                'backgroundColor'
            );
        }
    }
}).filter('carClass', ['broadcastService', function(broadcastService) {
    return (items, selectedCarClass) => {
        if (!selectedCarClass || broadcastService.isMixedClassMode(selectedCarClass)) {
            return items;
        }

        return _.filter(items, { carClass: selectedCarClass });
    }
}]);
